
#Import "<std>"
#Import "<mojo>"

#Import "assets/"

Using std..
Using mojo..

Class ImageRenderTarget

	Field image:Image
	Field canvas:Canvas

	Method New (width:Int, height:Int, centered:Bool = True)

		' Adapted from DoctorWhoof's Plane Demo -- thanks, DoctorWhoof!

		image = New Image (width, height, TextureFlags.Dynamic, Shader.Open ("basic"))

		If centered
			image.Handle = New Vec2f (0.5, 0.5)
		Endif
		
		image.Material.SetInt ("Toggle", False)
		
		canvas = New Canvas (image)
		
		canvas.Clear (Color.Brown)
		canvas.TextureFilteringEnabled = False
		
	End
	
End

Class Demo Extends Window

	Const WINDOW_WIDTH:Int			= 960
	Const WINDOW_HEIGHT:Int			= 540
	Const WINDOW_FLAGS:WindowFlags	= WindowFlags.Resizable

	Field x:Float
	Field y:Float
	Field width:Float = 2
	Field height:Float = 2
	
	Field xdir:Float = 1
	Field ydir:Float = 1
	
	Field toggle:Bool
	
	Field target:ImageRenderTarget
	
	Method New (title:String = "Image Shader Demo", width:Int = WINDOW_WIDTH, height:Int = WINDOW_HEIGHT, flags:WindowFlags = WINDOW_FLAGS)
		Super.New (title, width, height, flags)
	End

	Method OnCreateWindow () Override
		target = New ImageRenderTarget (640, 480)
		Mouse.PointerVisible = False
	End
	
	Method OnRender (canvas:Canvas) Override
	
		RequestRender ()

		If Keyboard.KeyHit (Key.Space)
			toggle = Not toggle
			target.image.Material.SetInt ("Toggle", toggle)
		Endif
		
		If Keyboard.KeyHit (Key.Escape) Then App.Terminate ()

		x = x + xdir
		y = y + ydir
		
		If x < 0 Or x > target.canvas.Viewport.Width
			xdir = -xdir
			x = x + xdir
		Endif
		
		If y < 0 Or y > target.canvas.Viewport.Height
			ydir = -ydir
			y = y + ydir
		Endif
		
		target.canvas.Color = Color.Rnd ()
		target.canvas.DrawRect (x, y, width, height)
		target.canvas.Flush ()

		canvas.TextureFilteringEnabled = False
		canvas.Clear (Color.Pine)
		canvas.DrawImage (target.image, canvas.Viewport.Width * 0.5, canvas.Viewport.Height * 0.5)', (Pi / 180.0) * angle)
		canvas.DrawText ("Space to toggle B & W shader", 20, 20)
		
	End

End

Function Main ()

	New AppInstance
	New Demo
	
	App.Run ()

End
